﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.SqlClient;
using DotNet.FrameWork.Data;
using HaTeam.Dd.Model;

namespace HteamDd.Web.Web.Dd_discover
{
    public partial class Dd_FerverTag : System.Web.UI.Page
    {
        public string user_Mes;
        List<String> lsBlogName = new List<string>();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (Session["user_Message"] != null)
                {
                    user_Mes = Session["user_Message"].ToString();
                    GetFever();
                }
                else
                {
                    Response.Redirect("/Dd_login.aspx");
                }
                ;
            }
        }
        /// <summary>
        /// 获取热门标签列表（取前20名）
        /// </summary>
        public void GetFever()
        {
            List<HotLabel> lhot = new List<HotLabel>();
            SqlDataReader reader = DbHelperSQL.ExecuteReader("select top(20) Lable,MAX(Fever) '_Fever' from view_tables group by Lable order by _Fever desc");
            while (reader.Read())
            {
                HotLabel hot = new HotLabel();
                hot.lable = reader.GetValue(0).ToString();
                hot.Fever = reader.GetValue(1).ToString();
                lhot.Add(hot);
            }
            this.RephotList.DataSource = lhot;
            RephotList.DataBind();
        }

        /// <summary>
        /// 返回标签热度等级
        /// </summary>
        /// <param name="hotCount">热度值</param>
        /// <returns>热度等级</returns>
        public string GetHotNum(int hotCount)
        {
            string hotstr = "";
            int grade = (hotCount / 2000) + 1;
            for (int i = 0; i < grade; i++)
            {
                hotstr += "<s class='hot-bar'></s>";
            }
            if (grade == 5)
            {
                return hotstr;
            }
            for (int j = 0; j < 5 - grade; j++)
            {
                hotstr += "<s class='hot-bar inactive'></s>";
            }
            return hotstr;
        }

        /// <summary>
        /// 返回内容活跃度
        /// </summary>
        /// <param name="lable">标签名</param>
        /// <returns>活跃值</returns>
        public string GetHotHeight(string lable)
        {
            int height;
            bool first = true;
            string tall = "";
            try
            {
                SqlDataReader reader = DbHelperSQL.ExecuteReader("select top(7) Fever from view_tables where Lable='" + lable.Trim() + "'");

                while (reader.Read())
                {
                    object getvalue = reader.GetValue(0) == DBNull.Value ? 0 : reader.GetValue(0);
                    height = (Convert.ToInt32(getvalue) / 400) + 1;
                    if (first == true)
                    {
                        tall += "<s class='active-bar odd' style='height:" + height + "px'></s>";
                        first = false;
                    }
                    else
                    {
                        tall += "<s class='active-bar even' style='height:" + height + "px'></s>";
                        first = true;
                    }

                }
                return tall;
            }
            catch(Exception ex)
            { 
                return  ex.ToString();
            }
        }

        /// <summary>
        /// 根据热门标签检索出热度最高的但与之前不重复的博客名
        /// </summary>
        /// <param name="lable">热门标签</param>
        /// <param name="name">确定返回什么值</param>
        /// <returns>返回博客名</returns>
        public string GetBlogName(string lable, string name)
        {
            string oldblogName = "'',";
            for (int i = 0; i < lsBlogName.Count; i++)
            {
                oldblogName += "'" + lsBlogName[i] + "',";
            }
            string blogname = "", blogimg = "";
            SqlDataReader reader = DbHelperSQL.ExecuteReader("select top(1) d_user.User_HeadPhoto,d_user.User_BlogName from view_tables v_tb,Dd_User d_user"
+ " where Lable='" + lable + "' and v_tb.User_ID=d_user.User_ID and d_user.User_BlogName not in(" + oldblogName.Remove(oldblogName.Length - 1) + ")  order by Fever desc");
            while (reader.Read())
            {
                //路径，须更改
                blogimg = reader.GetValue(0).ToString();
                //博客名
                blogname = reader.GetValue(1).ToString();
                lsBlogName.Add(blogname);
            }
            if (name == "img") { return blogimg; }
            return blogname;
        }

    }
}